/******************************************************************************
* This Program is the Confidential and Proprietary product of Altera Corp.    *
* Any unauthorized use,  reproduction or transfer of this program is strictly *
* prohibited. Copyright (c)  1993  by Altera Corp. All Rights Reserved.       *
*******************************************************************************/
/*

LIBRARY        : alteralib; Rev 1.0; February 93
FUNCTION       : QUAD D-TYPE FLIP-FLOP WITH 3-STATE OUTPUTS
TRUTHTABLE     : 

      -------------------------------
       CLR   CLK    G1_  G2_  D   Q
      -------------------------------
       H      X     X    X    X    L      
       L      L     X    X    X    QN
               _       
       L     _/     H    X    X    QN
               _       
       L     _/     X    H    X    QN
               _       
       L     _/     L    L    L    L 
               _       
       L     _/     L    L    H    H   
       
      -------------------------------  

Note :  High M or N drives Q to Z-state but does 
        not affect internal state of flip flops.

REFERENCE      : Altera MAX+Plus II online help, component description
DESIGNER       : AMI VIDER
DATE GENERATED : February 1993
DATE MODIFIED  : August 1993

VERITOOL COMPATIBILITY : Verilog x.x, Veritime y.y

*/
`celldefine

`timescale  1ns /  100ps
module a173 (m, n, q1, q2, q3, q4, clk, g1n, g2n, d4, d3, d2, d1, clr);
	parameter size =1;
	input
		g1n,
		g2n,
		clk,
		m,
		n,
		clr,
		d1,
		d2,
		d3,
		d4;
	output
		q1,
		q2,
		q3,
		q4;
    reg
        NOTIFY_REG;
    nor
	N1 (en1, g1n, g2n, clr);
    nor
	N2 (en2, g2n, clr);
    nor
	N3 (en3, g1n, clr);
    nor
	M173_inst_N1 (m173_inst_ge, g1n, g2n);
    nor
	M173_inst_N2 (m173_inst_oc, m, n);
    not
	M173_inst_N3 (m173_inst_geb, m173_inst_ge);
    not  
	M173_inst_N4 (m173_inst_clrb, clr);
    bufif1  
	M173_inst_B1 (q1, m173_inst_wq1, m173_inst_oc);
    bufif1  
	M173_inst_B2 (q2, m173_inst_wq2, m173_inst_oc);
    bufif1  
	M173_inst_B3 (q3, m173_inst_wq3, m173_inst_oc);
    bufif1  
	M173_inst_B4 (q4, m173_inst_wq4, m173_inst_oc);
    U_AO_2_2
	M173_inst_inst11_inst1 (m173_inst_wd1, m173_inst_wq1, m173_inst_geb, d1, m173_inst_ge);
    U_AO_2_2
	M173_inst_inst12_inst1 (m173_inst_wd2, m173_inst_wq2, m173_inst_geb, d2, m173_inst_ge);
    U_AO_2_2
	M173_inst_inst13_inst1 (m173_inst_wd3, m173_inst_wq3, m173_inst_geb, d3, m173_inst_ge);
    U_AO_2_2
	M173_inst_inst14_inst1 (m173_inst_wd4, m173_inst_wq4, m173_inst_geb, d4, m173_inst_ge);
    U_FD_P_RB_NO  
	M173_inst_Inst1_inst1 (m173_inst_wq1, m173_inst_wd1, clk, m173_inst_clrb, NOTIFY_REG);
    U_FD_P_RB_NO  
	M173_inst_Inst2_inst1 (m173_inst_wq2, m173_inst_wd2, clk, m173_inst_clrb, NOTIFY_REG);
    U_FD_P_RB_NO  
	M173_inst_Inst3_inst1 (m173_inst_wq3, m173_inst_wd3, clk, m173_inst_clrb, NOTIFY_REG);
    U_FD_P_RB_NO  
	M173_inst_Inst4_inst1 (m173_inst_wq4, m173_inst_wd4, clk, m173_inst_clrb, NOTIFY_REG);

    specify

	// Synthesis parameters

`ifdef SYNTH
	specparam Area = 1;
`endif



    endspecify

endmodule
`endcelldefine
